﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIRP.EFR.DAL.Imaging.Utility
{
    public sealed class CacheKey
    {
        private const char SEPARATOR = '|';
        private const string EmptyPart = "NONE";

        private readonly StringBuilder builder;

        public CacheKey()
        {
            this.builder = new StringBuilder();
        }

        public CacheKey(string cachedItemIdentifier)
        {
            this.builder = new StringBuilder();

            this.AddPart(cachedItemIdentifier);
        }

        public CacheKey(
            string nameSpace,
            string className,
            string method)
        {
            this.builder = new StringBuilder();

            this.AddPart(nameSpace);
            this.AddPart(className);
            this.AddPart(method);
        }

        public CacheKey AddPart<T>(T part)
        {
            string partString = EmptyPart;

            if (part != null)
                partString = part.ToString();

            this.builder.Append(SEPARATOR + partString);
            //_builder.Append($"{SEPARATOR}{partString}");

            return this;
        }

        public string Build()
        {
            return this.builder.ToString();
        }
    }
}
